local assets =
{
    Asset("ANIM", "anim/roncatamulet_anim.zip"),
    Asset("ANIM", "anim/roncatamulet.zip"),
    Asset("ANIM", "anim/torso_roncatamulet.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatamulet.xml"),
    Asset("ANIM", "anim/roncatamulet_guardian.zip"),
    Asset("ANIM", "anim/torso_roncatamulet_guardian.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatamulet_guardian.xml"),
    Asset("ANIM", "anim/roncatamulet_peace.zip"),
    Asset("ANIM", "anim/torso_roncatamulet_peace.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatamulet_peace.xml"),
}

local function calmtargets(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if not owner then return end
	
    local x, y, z = owner.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x, y, z, 20, {"_combat"}, { "INLIMBO" })
	for k,v in pairs(ents) do
		if math.random() < 0.1 
		and v.components.combat.target == owner 
		then
			-- Drop target if this is the amulet holder
			v.components.combat:DropTarget()
		end
		if math.random() < 0.1 
		and v.components.combat.target ~= nil
		and (v.components.combat.target:HasTag("companion")
			or (not (v.components.follower and v.components.follower.leader and v.components.follower.leader:HasTag("roncatguardian")) and v.components.combat.target:HasTag("player")))
		and not v.components.combat.target:HasTag("roncattargettaker")
		then
			-- Drop target if team member that isn't target taker
			v.components.combat:DropTarget()
		end
	end
end
local function taketargets(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if not owner then return end
    local x, y, z = owner.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x, y, z, 15, {"_combat"}, { "INLIMBO" })
	for k,v in pairs(ents) do
		if math.random() < 0.1
		and v.components.combat.target ~= nil
		and v.components.combat.target ~= owner
		and (v.components.combat.target:HasTag("companion")
			or v.components.combat.target:HasTag("player"))
		and not IsJinxed(v.components.combat.target)
		then
			-- Take target if team member isn't jinx (jinx will be retargeted anyway)
			v.components.combat:SetTarget(owner)
		end
	end
end
local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "torso_roncatamulet", "swap_body")
    if inst.components.fueled then
        inst.components.fueled:StartConsuming()        
    end
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    if inst.components.fueled then
        inst.components.fueled:StopConsuming()
    end
end

local function onequip_peace(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "torso_roncatamulet_peace", "swap_body")
	owner:AddTag("roncatcalmer") -- Reduced aggression and damage
    if inst.components.fueled then
        inst.components.fueled:StartConsuming()        
    end
	if inst.calmertask then
		inst.calmertask:Cancel()
		inst.calmertask = nil
	end
	inst.calmertask = inst:DoPeriodicTask(2, calmtargets)
end

local function onunequip_peace(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("roncatcalmer")
    if inst.components.fueled then
        inst.components.fueled:StopConsuming()
    end
	if inst.calmertask then
		inst.calmertask:Cancel()
		inst.calmertask = nil
	end
end

local function onequip_guardian(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "torso_roncatamulet_guardian", "swap_body")
	owner:AddTag("roncatguardian") -- Take team damage
	owner.guardianamulet = inst
    if inst.components.fueled then
        inst.components.fueled:StartConsuming()        
    end
	if inst.guardiantask then
		inst.guardiantask:Cancel()
		inst.guardiantask = nil
	end
	inst.guardiantask = inst:DoPeriodicTask(2, taketargets)
end

local function onunequip_guardian(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("roncatguardian")
	owner.guardianamulet = inst
    if inst.components.fueled then
        inst.components.fueled:StopConsuming()
    end
	if inst.guardiantask then
		inst.guardiantask:Cancel()
		inst.guardiantask = nil
	end
end


local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "anim")
	end
	
    inst.AnimState:SetBank("roncatamulet")
    inst.foleysound = "dontstarve/movement/foley/jewlery"

    inst:AddComponent("inspectable")

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.NECK or EQUIPSLOTS.BODY

    inst:AddComponent("inventoryitem")
	
    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "MAGIC"
    inst.components.fueled:SetDepletedFn(inst.Remove)

    return inst
end

local function clover()
	local inst = fn()
	
    inst.AnimState:SetBuild("roncatamulet")
    inst.AnimState:PlayAnimation("anim")
	
	inst:AddTag("roncatluckywear") -- Prevents jinx when equipping
	
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED
	end	
	
    inst.components.fueled:InitializeFuelLevel(480*2)
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatamulet.xml"
	
	return inst
end

local function guardian()
	local inst = fn()
	
    inst.AnimState:SetBuild("roncatamulet_guardian")
    inst.AnimState:PlayAnimation("anim")
	
    inst.components.equippable:SetOnEquip(onequip_guardian)
    inst.components.equippable:SetOnUnequip(onunequip_guardian)
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL
	end
	
    inst.components.fueled:InitializeFuelLevel(480*1.5)
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatamulet_guardian.xml"
	
	return inst
end

local function peace()
	local inst = fn()
	
    inst.AnimState:SetBuild("roncatamulet_peace")
    inst.AnimState:PlayAnimation("anim")
	
    inst.components.equippable:SetOnEquip(onequip_peace)
    inst.components.equippable:SetOnUnequip(onunequip_peace)
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL
	end
	
    inst.components.fueled:InitializeFuelLevel(480*1.5)   
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatamulet_peace.xml"
	
	return inst
end

--[[
local function discord()
	local inst = fn()
	
    inst.AnimState:SetBuild("roncatamulet_discord")
    inst.AnimState:PlayAnimation("anim")
	
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst.components.equippable.dapperness = -TUNING.DAPPERNESS_MED
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = -TUNING.DAPPERNESS_MED
	end
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatamulet_discord.xml"
	
	return inst
end
]]


return Prefab("common/inventory/roncatamulet", clover, assets),
 Prefab("common/inventory/roncatamulet_guardian", guardian, assets),
 Prefab("common/inventory/roncatamulet_peace", peace, assets)
